<?php

namespace App\ApiRequest;

class GetPartyAddressByOrdStopsTrait
{
    /* get stops full address for shipment order from stops */
    public static function getPartyAddrByOrdStops(
        array $stops,
        int $index,
        \CI_DB_mysqli_driver $db
    ) {
        $response = array('source' => "", "destination" => "", "source_party" => "", "dest_party" => "");
        $pickparty = "Shipper";
        $deliverparty = "Consignee";
        if ($stops['cmpcode'] == "SGKN" || $stops['cmpcode'] == "MYKN") {
            $pickparty = "PICKUP";
            $deliverparty = "DELIVERY";
        }
        /* source stop */
        if ($stops['sstop'] != 0) {
            $shipid = $stops['shipment_id'];
            $ordpickup = $db->query("SELECT o.id FROM tb_orders o,tb_employee e WHERE o.order_id=e.order_id AND e.shift_id='" . $shipid . "' AND e.stop_id='" . $stops['sstop'] . "' AND e.status=1");
            if ($ordpickup->num_rows() > 0) {
                $ordid = $ordpickup->row($index)->id;
                $addrresp = static::getAddrByPartyTypeOrder($ordid, $pickparty, $db);
                if (!empty($addrresp)) {
                    $response['source'] = isset($addrresp['address']) ? $addrresp['address'] : "";
                    $response['source_party'] = isset($addrresp['address_party']) ? $addrresp['address_party'] : "";
                } else {
                    if ($pickparty == "PICKUP") {
                        $addrresp = static::getAddrByPartyTypeOrder($ordid, 'Shipper', $db);
                        if (!empty($addrresp)) {
                            $response['source'] = isset($addrresp['address']) ? $addrresp['address'] : "";
                            $response['source_party'] = isset($addrresp['address_party']) ? $addrresp['address_party'] : "";
                        }
                    }
                }
            }
        }
        /* delivery stop */
        if ($stops['dstop'] != 0) {
            $shipid = $stops['shipment_id'];
            $orddrop = $db->query("SELECT o.id FROM tb_orders o,tb_employee e WHERE o.order_id=e.order_id AND e.shift_id='" . $shipid . "' AND e.drop_stopid='" . $stops['dstop'] . "' AND e.status=1");
            if ($orddrop->num_rows() > 0) {
                $ordid = $orddrop->row($index)->id;
                $addrresp = static::getAddrByPartyTypeOrder($ordid, $deliverparty, $db);
                if (!empty($addrresp)) {
                    $response['destination'] = isset($addrresp['address']) ? $addrresp['address'] : "";
                    $response['dest_party'] = isset($addrresp['address_party']) ? $addrresp['address_party'] : "";
                } else {
                    if ($deliverparty == "DELIVERY") {
                        $addrresp = static::getAddrByPartyTypeOrder($ordid, 'Consignee', $db);
                        if (!empty($addrresp)) {
                            $response['destination'] = isset($addrresp['address']) ? $addrresp['address'] : "";
                            $response['dest_party'] = isset($addrresp['address_party']) ? $addrresp['address_party'] : "";
                        }
                    }
                }
            }
        }
        return $response;
    }

    /*get address by order and order party type */
    private static function getAddrByPartyTypeOrder(
        string $ordid,
        string $stoppartytype,
        \CI_DB_mysqli_driver $db
    ) : array {
        $addrresponse = array();
        $qry = "SELECT o.pickup_company,o.pickup_city,o.pickup_pincode,o.pickup_country,o.pickup_address1,o.pickup_address2,m.name,m.location_id,m.address,m.state,m.street,m.pincode,m.street_2,m.street_3,t.name as partytype FROM tb_orders o,tb_order_parties p,tbl_party_master m,tbl_party_types t WHERE o.id=p.order_id AND o.id='" . $ordid . "' AND p.party_id=m.id AND p.party_type=t.id AND t.name='" . $stoppartytype . "' AND p.status =1 AND m.status=1 LIMIT 1";
        $partyqry = $db->query($qry);
        if ($partyqry->num_rows() > 0) {
            if ($partyqry->row()->partytype == $stoppartytype) {
                $res = $partyqry->row_array();
                $scity = $res['location_id'];
                if ($scity == "") {
                    $scity = $res['pickup_city'];
                }
                $sstate = $res['state'];
                $scountry = $res['pickup_country'];
                $spincode = $res['pincode'];
                if ($spincode == "") {
                    $spincode = $res['pickup_pincode'];
                }
                $saddress1 = $res['street'];
                if ($saddress1 == "") {
                    $saddress1 = $res['pickup_address1'];
                }
                $saddress2 = $res['address'];
                if ($saddress2 == "") {
                    $saddress2 = $res['pickup_address2'];
                }
                if ($res['street_2'] != "") {
                    $saddress2 .= ", " . $res['street_2'];
                }
                if ($res['street_3'] != "") {
                    $saddress2 .= ", " . $res['street_3'];
                }
                if ($saddress2 != "") {
                    $source = $saddress1 . ", " . $saddress2 . ", " . $scity . ", " . $sstate . ", " . $scountry . ", " . $spincode;
                } else {
                    $source = $saddress1 . ", " . $scity . ", " . $sstate . ", " . $scountry . ", " . $spincode;
                }
                $sourcstr = explode(",", $source);
                $sourcestr = array_map("trim", $sourcstr);
                $sourcestr1 = array_unique($sourcestr);
                $sourcedata = implode(", ", $sourcestr1);
                $addrresponse['address'] = $sourcedata;
                $addrresponse['address_party'] = $res['name'];
            }
        }
        return $addrresponse;
    }
}
