<?php

namespace App\ApiRequest;

class GetPartyInformation
{
    private static $PICKUP = "P";
    private static $DELIVERY = "D";

    /* get stops full address for shipment order from stops */
    public static function getPartyAddrByOrdStops(
        array $stops,
        int $index,
        \CI_DB_mysqli_driver $db
    ): array {
        $response = ['source' => "", "destination" => "", "source_party" => "", "dest_party" => ""];
        /* source stop */
        if ($stops['sstop'] != 0) {
            $shipid = $stops['shipment_id'];

            $ordpickup = $db->query("SELECT o.id FROM tb_orders o, tb_employee e 
                WHERE o.order_id = e.order_id 
                  AND e.shift_id=? AND e.stop_id=? AND e.status = 1", [$shipid,  $stops['sstop']]);
            if ($ordpickup->num_rows() > 0) {
                $ordid = $ordpickup->row($index)->id;
                $addrresp = self::getPartyInfoByOrderIdPartyType($ordid, static::$PICKUP, $db);
                if (!empty($addrresp)) {
                    $response['source'] = $addrresp['address'] ?? "";
                    $response['source_party'] = $addrresp['address_party'] ?? "";
                }
            }
        }
        /* delivery stop */
        if ($stops['dstop'] != 0) {
            $shipid = $stops['shipment_id'];

            $orddrop = $db->query("SELECT o.id FROM tb_orders o, tb_employee e 
                WHERE o.order_id = e.order_id 
                  AND e.shift_id =? AND e.drop_stopid = ? AND e.status = 1", [$shipid,  $stops['dstop']]);
            if ($orddrop->num_rows() > 0) {
                $ordid = $orddrop->row($index)->id;
                $addrresp = self::getPartyInfoByOrderIdPartyType($ordid, static::$DELIVERY, $db);
                if (!empty($addrresp)) {
                    $response['destination'] = $addrresp['address'] ?? "";
                    $response['dest_party'] = $addrresp['address_party'] ?? "";
                }
            }
        }
        return $response;
    }

    /*get source and delivery addresses by party types of shipment */
    public static function getPartyInfoByOrderId(
        $orderId,
        \CI_DB_mysqli_prod_driver $db
    ): array {
        $address = [];
        $partyQueryString = "SELECT o.pickup_company, o.pickup_city, o.pickup_pincode, 
       o.pickup_country, o.pickup_address1, o.pickup_address2, o.delivery_company, 
       o.delivery_address1, o.delivery_address2, o.delivery_city, o.delivery_country,
       o.delivery_pincode
            FROM tb_orders o
            WHERE o.id = ?
            LIMIT 1";
        $partyQuery = $db->query($partyQueryString, [$orderId]);
        if ($partyQuery->num_rows() > 0) {
            $res = $partyQuery->row_array();
            $address['source'] = self::preparePickupAddress($res);
            $address['destination'] = self::prepareDeliveryAddress($res);
            $address['source_party'] = $res['pickup_company'];
            $address['dest_party'] = $res['delivery_company'];
        }
        return $address;
    }

    /*get address by order and order party type */
    public static function getPartyInfoByOrderIdPartyType(
        string $orderId,
        string $partyType,
        \CI_DB_mysqli_prod_driver $db
    ): array {
        $address = [];
        $partyQueryString = "SELECT o.pickup_company, o.pickup_city, o.pickup_pincode, 
        o.pickup_country, o.pickup_address1, o.pickup_address2, o.delivery_company, 
       o.delivery_address1, o.delivery_address2, o.delivery_city, o.delivery_country, 
       o.delivery_pincode
            FROM tb_orders o
            WHERE o.id = ?
            LIMIT 1";
        $partyQuery = $db->query($partyQueryString, [$orderId]);
        if ($partyQuery->num_rows() > 0) {
            $res = $partyQuery->row_array();
            if ($partyType == static::$PICKUP) {
                $addressParts = self::preparePickupAddressParts($res);
                $address['address_party'] = $res['pickup_company'];
            } else {
                $addressParts = self::prepareDeliveryAddressParts($res);
                $address['address_party'] = $res['delivery_company'];
            }
            $address['address'] = GetPartyInformation::prepareAddress($addressParts);
        }
        return $address;
    }

    /**
     * @param $res
     * @return string
     */
    private static function preparePickupAddress($res): string
    {
        $addressParts = static::preparePickupAddressParts($res);
        return GetPartyInformation::prepareAddress($addressParts);
    }

    /**
     * @param $res
     * @return string
     */
    private static function prepareDeliveryAddress($res): string
    {
        $addressParts = static::prepareDeliveryAddressParts($res);
        return GetPartyInformation::prepareAddress($addressParts);
    }

    /**
     * @param $res
     * @return array
     */
    private static function preparePickupAddressParts($res): array
    {
        $addressParts = [];
        if (!empty($res["pickup_address1"])) {
            $addressParts[] = trim($res["pickup_address1"]);
        }
        if (!empty($res["pickup_address2"])) {
            $addressParts[] = trim($res["pickup_address2"]);
        }
        if (!empty($res["pickup_city"])) {
            $addressParts[] = trim($res["pickup_city"]);
        }
        if (!empty($res["pickup_country"])) {
            $addressParts[] = trim($res["pickup_country"]);
        }
        if (!empty($res["pickup_pincode"])) {
            $addressParts[] = trim($res["pickup_pincode"]);
        }
        return $addressParts;
    }

    /**
     * @param $res
     * @param $addressParts
     * @return array
     */
    private static function prepareDeliveryAddressParts($res): array
    {
        $addressParts = [];
        if (!empty($res["delivery_address1"])) {
            $addressParts[] = trim($res["delivery_address1"]);
        }
        if (!empty($res["delivery_address2"])) {
            $addressParts[] = trim($res["delivery_address2"]);
        }
        if (!empty($res["delivery_city"])) {
            $addressParts[] = trim($res["delivery_city"]);
        }
        if (!empty($res["delivery_country"])) {
            $addressParts[] = trim($res["delivery_country"]);
        }
        if (!empty($res["delivery_pincode"])) {
            $addressParts[] = trim($res["delivery_pincode"]);
        }
        return $addressParts;
    }

    public static function prepareAddress(array $addressParts): string
    {
        $mergedAddress = implode(",", $addressParts);
        $addressParts = explode(",", $mergedAddress);
        $addressParts = array_map('trim', $addressParts);
        $addressParts = array_unique($addressParts);
        return implode(", ", $addressParts);
    }
}
