<?php

namespace App\Authorization;

use App\Authorization\Exception\AuthorizationDeniedException;
use App\Authorization\Exception\EntityAuthorizerNotFoundException;
use App\Authorization\Session\UserSession;
use App\Authorization\Session\UserSessionInterface;
use InvalidArgumentException;

final class Authorization
{
    public const ENTITY_TYPE_ORDER = 'order';

    /**
     * @throws EntityAuthorizerNotFoundException
     * @throws AuthorizationDeniedException
     * @throws InvalidArgumentException
     */
    public function isAuthorized(UserSessionInterface $userSession, $entityName, $entityId, $ci): bool
    {
        $authorizationChecker = (new EntityAuthorizerFactory($ci))->buildEntityAuthorizer($entityName);

        switch ($userSession->userType()) {
            case UserSession::USER_TYPE_COUNTRY_ADMIN:
                return $authorizationChecker->authorizeCountryAdmin($userSession, $entityId);
            case UserSession::USER_TYPE_APP_ADMIN:
                return $authorizationChecker->authorizeAppAdmin($userSession, $entityId);
            case UserSession::USER_TYPE_USER:
                return $authorizationChecker->authorizeUser($userSession, $entityId);
            case UserSession::USER_TYPE_CUSTOMER:
                return $authorizationChecker->authorizeCustomer($userSession, $entityId);
            case UserSession::USER_TYPE_CARRIER:
                return $authorizationChecker->authorizeCarrier($userSession, $entityId);
            default:
                return false;
        }
    }
}
