<?php

namespace App\Authorization\Authorizer;

use App\Authorization\Exception\AuthorizationDeniedException;
use App\Authorization\Session\UserSessionInterface;

interface EntityAuthorizerInterface
{
    /**
     * @throws AuthorizationDeniedException
     */
    public function authorizeAppAdmin(UserSessionInterface $userSession, $entityId): bool;

    /**
     * @throws AuthorizationDeniedException
     */
    public function authorizeCarrier(UserSessionInterface $userSession, $entityId): bool;

    /**
     * @throws AuthorizationDeniedException
     */
    public function authorizeCountryAdmin(UserSessionInterface $userSession, $entityId): bool;

    /**
     * @throws AuthorizationDeniedException
     */
    public function authorizeCustomer(UserSessionInterface $userSession, $entityId): bool;

    /**
     * @throws AuthorizationDeniedException
     */
    public function authorizeUser(UserSessionInterface $userSession, $entityId): bool;
}
