<?php

namespace App\EventsQueue\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\EventsQueue\Payload\TripNotificationPayload;
use App\MobileEvents\Handler\MobileEventHandler;
use SVKAPI\v1\TripNotification;

class TripNotificationHandler extends MobileEventHandler
{
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof TripNotificationPayload) {
            throw new \InvalidArgumentException('Invalid payload');
        }
        $dataset = $payload->getDataset();
        if (!key_exists('tripId', $dataset)) {
            throw new \Exception('TripID is missing in TripNotificationPayload');
        }

        $response = (new TripNotification())->process($dataset['tripId']);
        $this->CI = &get_instance();
        $this->CI->db->set('result', $response)
            ->like('payload', "{$dataset['identifier']}", 'both')
            ->update('tbl_events_queue');
    }
}


