<?php

namespace App\ExceptionHandler;

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\ForbiddenException;
use App\ApiRequest\DataPreprocessing\MethodNotAllowedException;
use App\ApiRequest\DataPreprocessing\NoDataFoundException;
use App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException;
use App\ApiRequest\DataPreprocessing\UnauthorizedException;

final class ApiException
{
    public static function isApiException(\Throwable $exception): bool
    {
        if (
            in_array(get_class($exception), [
                BadRequestException::class,
                MethodNotAllowedException::class,
                TimezoneNotSpecifiedException::class,
                NoDataFoundException::class
            ])
            || $exception instanceof NotFoundExceptionInterface
            || $exception instanceof ForbiddenException
            || $exception instanceof UnauthorizedException
        ) {
            return true;
        }

        return false;
    }
}
