<?php

namespace App\ExceptionHandler;

use App\ApiRequest\DataPreprocessing\ForbiddenException;
use App\ApiRequest\DataPreprocessing\MethodNotAllowedException;
use App\ApiRequest\DataPreprocessing\UnauthorizedException;

final class ApiExceptionHandler implements ExceptionHandler
{
    public function handleException(\Throwable $exception): void
    {
        $status = 400;

        if ($exception instanceof ForbiddenException) {
            $status = 403;
        } elseif ($exception instanceof UnauthorizedException) {
            $status = 401;
        } elseif ($exception instanceof MethodNotAllowedException) {
            $status = 405;
        } elseif ($exception instanceof NotFoundExceptionInterface) {
            $status = 404;
        }

        set_status_header($status);

        echo json_encode([
            'status' => 'failure',
            'message' => $exception->getMessage()
        ]);
    }
}
