<?php

namespace App\Generators;

final class RandomOrderSequence
{
    public static function generate(
        \CI_DB_mysqli_driver $db,
        string $user_id,
        string $country_code
    ): array {
        $seq_num = 000001;
        $ordchk = $db->select("id,order_id")
            ->order_by('id', 'DESC')
            ->get_where('tb_orders', ["user_id" => $user_id], 1, 0);

        $year = date('y');
        $week = date('W');
        if ($ordchk->num_rows() > 0) {
            $order_id = ($ordchk->row()->id + 1);
            $order_nm = $ordchk->row()->order_id;
            $seq_num = substr($order_nm, -6);
            $week_order_number = $order_nm;
            $country_codelength = strlen($country_code);
            $wcount = $country_codelength + 2;
            $previous_weeknumber = mb_substr($week_order_number, $wcount, 2);
            $idlength = strlen($order_id);
            $ycount = $wcount + 2;
            $previous_ordernumber = mb_substr($week_order_number, $ycount, 5);
            $id = ltrim($previous_ordernumber, 0);
            if ($previous_weeknumber < $week) {
                $id = '0001';
            } else {
                $i_id = $id;
                $i_id++;
                $idlength = strlen($i_id);
                if ($idlength == '1') {
                    $id = "000" . $i_id;
                } else {
                    if ($idlength == '2') {
                        $id = "00" . $i_id;
                    } else {
                        if ($idlength == '3') {
                            $id = "0" . $i_id;
                        } else {
                            if ($idlength == '4') {
                                $id = $i_id;
                            } else {
                                $id = $i_id;
                            }
                        }
                    }
                }
            }
            $ord = $country_code . $year . $week . $id;
        } else {
            $i_id = 1;
            $id = '000' . $i_id;
            $ord = $country_code . $year . $week . $id;
        }
        $shiptxn = "T" . $country_code . $week . $year . $seq_num;

        return [$ord, $shiptxn];
    }

}
