<?php

declare(strict_types=1);

namespace App\Integrations\Mft\Backup;

use App\Time\TimerInterface;

final class TimeStrategy
{
    private string $filePath;
    private TimerInterface $timer;

    public function __construct(string $filePath, TimerInterface $timer)
    {
        if (trim($filePath) === '') {
            throw new \Exception('File Path cannot be empty');
        }

        $this->filePath = $filePath;
        $this->timer = $timer;
    }

    public function getBackupPath(): string
    {
        $sourceDir = dirname($this->filePath);
        $fileName = basename($this->filePath);

        $timestamp = $this->timer->getTimestamp();

        return $sourceDir . DIRECTORY_SEPARATOR
            . 'backup' . DIRECTORY_SEPARATOR
            . date('Y', $timestamp) . DIRECTORY_SEPARATOR
            . date('m', $timestamp) . DIRECTORY_SEPARATOR
            . date('d', $timestamp) . DIRECTORY_SEPARATOR
            . $fileName;
    }

    public function getBackupFolder(): string
    {
        $sourceDir = dirname($this->filePath);
        $timestamp = $this->timer->getTimestamp();

        return $sourceDir . DIRECTORY_SEPARATOR
            . 'backup' . DIRECTORY_SEPARATOR
            . date('Y', $timestamp) . DIRECTORY_SEPARATOR
            . date('m', $timestamp) . DIRECTORY_SEPARATOR
            . date('d', $timestamp) . DIRECTORY_SEPARATOR;
    }
}
