<?php

declare(strict_types=1);

namespace App\Integrations\Salog\ePod;

use App\PodUploads\Constants\DocumentType;

abstract class AbstractXMLData implements XmlDataInterface
{
    public static function getDataProvider(string $documentTypeCode): XmlDataInterface {
        if ($documentTypeCode == DocumentType::PUP) {
            return new PickupXMLData();
        }

        return new DeliveryXMLData();
    }

    abstract public function getStopType(): string;
    abstract public function getOrderType(): string;

    public function getData(
        string $shipmentId,
        string $tripId,
        string $stopId,
        string $orderNumber,
        string $orderId,
        string $latitude,
        string $longitude
    ): array {
        $ci = &get_instance();
        $timezone = $ci->session->userdata("usr_tzone")['timezone'];
        $hours = $ci->session->userdata("usr_tzone")['hrs'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $timezone);
        $curdt = $getactual['datetime'];

        return [
            "shipment_id" => $shipmentId,
            "trip_id" => $tripId,
            "driver_id" => 0,
            "stop_id" => $stopId,
            "order_id" => $orderNumber,
            "inc_id" => 0,
            "pod_type" => '',
            "latitude" => $latitude,
            "longitude" => $longitude,
            "stop_type" => $this->getStopType(),
            "vehicle_id" => 0,
            "curtz" => $timezone,
            "hrs" => $hours,
            "web" => $curdt,
            "ord_id" => $orderId
        ];
    }
}
