<?php

declare(strict_types=1);

namespace App\Integrations\Salog\ePod;

use Salogintegrateservice;

final class IntegrationService
{
    private Salogintegrateservice $salogIntegrateService;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->library("salogintegrateservice");

        $this->salogIntegrateService = $ci->salogintegrateservice;
    }

    public function sendePod(array $salogXMLData, string $orderType): void
    {
        $this->salogIntegrateService->sendePodToSalog($salogXMLData, $orderType);
    }
}
