<?php

namespace App\Mobile\V1\Authentication;

class GetNewAuthorization
{
    /**
     * @throws StrongRandomnessMissingException
     */
    public static function get(\CI_Cache $cache): string
    {
        $bytes = openssl_random_pseudo_bytes(25, $isStrongResult);
        $authorization   = bin2hex($bytes);

        if ($isStrongResult !== true) {
            throw new StrongRandomnessMissingException();
        }

        $cache->save(AuthorizationCache::key($authorization), ['shipmentIds' => []], AuthorizationCache::TIME);
        return $authorization;
    }
}
