<?php

namespace App\Mobile\V1\Authentication;

use App\ApiRequest\DataPreprocessing\ForbiddenException;
use CI_Cache;

class GetShipmentIdsFromAuthorization
{
    public static function getShipmentIdsFromAuthorization(
        string $authorization,
        CI_Cache $cache
    ): array {
        $cacheKey = AuthorizationCache::key($authorization);
        $list = $cache->get($cacheKey);
        if ($list === false) {
            throw new ForbiddenException("Authorization is not valid.");
        }
        return $list['shipmentIds'];
    }
}
