<?php

namespace App\Mobile\V1\Trips\Actions;

class ActionDiscrepancy
{
    const DAMAGED = [
        'status_code' => '0502', //P - 0502; Reason Code DD02 | D - 3002; Reason Code DD02
        'status_id' => '12',
        'status_stage' => 'DELIVERED_WITH_DAMAGE',
        'identifier' => 'damaged',
        'description' => 'Pickup or Delivery contains damaged goods'
    ];

    const SHORT = [
        'status_code' => '0503', //3002, Reason Code DD01
        'status_id' => '13',
        'status_stage' => 'DELIVERY_SHORT',
        'identifier' => 'short',
        'description' => 'Delivery goods are missing'
    ];

    const SITE_CLOSED = [
        'status_code' => '0504',
        'status_id' => '14',
        'status_stage' => 'DELIVERY_NOT_DONE',
        'identifier' => 'siteClosed',
        'description' => 'Site closed for gate in'
    ];

    const REFUSED = [
        'status_code' => '0505', //3001; Reason Code DI03
        'status_id' => '15',
        'status_stage' => 'DELIVERY_REFUSED',
        'identifier' => 'refused',
        'description' => 'Delivery has been refused'
    ];

    public static $identifiers =
        [
            self::SITE_CLOSED['identifier'] => self::SITE_CLOSED,
            self::DAMAGED['identifier'] => self::DAMAGED,
            self::SHORT['identifier'] => self::SHORT,
            self::REFUSED['identifier'] => self::REFUSED
        ];
}