<?php

namespace App\Mobile\V1\Trips;

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\Mobile\V1\Authentication\GetShipmentIdsFromAuthorization;
use App\Mobile\V1\Trips\Exception\ShipmentIdsNotProvidedForAuthorizationException;
use App\Mobile\V1\Trips\Exception\ShipmentDoesNotBelongToAuthorizationException;

class CheckAuthorization
{
    private static $shipmentIds;

    /**
     * @param string $authorization
     * @param \CI_Cache $cache
     * @param string $shipmentId
     * @throws BadRequestException
     * @throws ShipmentIdsNotProvidedForAuthorizationException
     * @throws ShipmentDoesNotBelongToAuthorizationException
     * @throws \App\ApiRequest\DataPreprocessing\ForbiddenException
     */
    public static function isAuthorizedForShipment(string $authorization, \CI_Cache $cache, string $shipmentId) {
        self::checkForAnyShipment($authorization, $cache);

        if (!isset(static::$shipmentIds)) {
            throw new \LogicException(self::class . " not initialized before checking for shipment.");
        }

        if (!in_array($shipmentId, static::$shipmentIds)) {
            throw  new ShipmentDoesNotBelongToAuthorizationException('Shipment not found in token.');
        } elseif (empty($shipmentId)) {
            throw new BadRequestException('Invalid request');
        }
    }

    /**
     * @param string $authorization
     * @param \CI_Cache $cache
     * @throws ShipmentIdsNotProvidedForAuthorizationException
     * @throws \App\ApiRequest\DataPreprocessing\ForbiddenException
     */
    private static function checkForAnyShipment(string $authorization, \CI_Cache $cache) {
        static::$shipmentIds = GetShipmentIdsFromAuthorization::getShipmentIdsFromAuthorization($authorization, $cache);

        if (empty(static::$shipmentIds)) {
            throw new ShipmentIdsNotProvidedForAuthorizationException('Shipment IDs are missing');
        }
    }
}
