<?php

namespace App\Mobile\V1\Trips;

use App\Mobile\V1\Trips\Model\TripStatus;

final class GetNextTripStatus
{
    /**
     * @param string $currentStatusValue
     *
     * @return array
     */
    public static function getNextStatuses(string $currentStatusValue): array
    {
        $statusWorkflow = [
            TripStatus::NOT_STARTED => [TripStatus::STARTED, TripStatus::FINISHED],
            TripStatus::STARTED => [TripStatus::FINISHED],
            TripStatus::FINISHED => []
        ];

        return $statusWorkflow[$currentStatusValue] ?? [];
    }
}
