<?php

namespace App\Mobile\V1\Trips\Model;

class Location
{
    /**
     * @var float
     */
    private $lat;
    /**
     * @var float
     */
    private $long;

    public function __construct(float $lat, float $long)
    {
        $this->lat = $lat;
        $this->long = $long;
    }

    public function toArray(): array
    {
        return [
            'lat' => $this->lat,
            'long' => $this->long,
        ];
    }

    public static function fromArray(array $location): self
    {
        return new self($location['lat'], $location['long']);
    }
}
