<?php

namespace App\Mobile\V1\Trips\Model;

use Carbon\Carbon;

class Position
{
    /**
     * @var Location
     */
    private $location;
    /**
     * @var Carbon
     */
    private $date;

    public function __construct(Location $location, Carbon $date)
    {
        $this->location = $location;
        $this->date = $date;
    }

    public function toArray(): array
    {
        return [
            'location' => $this->location->toArray(),
            'date' => $this->date->toDateTime()->format("Y-m-d\TH:iO"),
        ];
    }

    public static function fromArray(array $position, string $curtz): self
    {
        return new self(
            Location::fromArray($position['location']),
            (new Carbon($position['date']))->tz($curtz),
        );
    }
}
