<?php

namespace App\Mobile\V1\Trips\Model;

use Carbon\Carbon;

class StopActionDetails
{
    /**
     * @var string
     */
    private $state;
    /**
     * @var Carbon
     */
    private $date;
    /**
     * @var Carbon
     */
    private $dateModified;
    /**
     * @var array
     */
    private $documents;
    /**
     * @var Position
     */
    private $position;
    /**
     * @var string
     */
    private $discrepancy;
    /**
     * @var string
     */
    private $comment;

    private $statusCode;

    const DEFAULT_COMMENT = '';

    public function __construct(
        string $state,
        ?Carbon $date,
        ?Carbon $dateModified,
        array $documents,
        ?Position $position,
        string $discrepancy,
        string $comment,
        ?string $statusCode = null
    )
    {
        $this->state = $state;
        $this->date = $date;
        $this->dateModified = $dateModified;
        $this->documents = $documents;
        $this->position = $position;
        $this->discrepancy = $discrepancy;
        $this->comment = $comment;
        $this->statusCode = $statusCode;
    }

    public function toArray(): array
    {
        $details = [
            'state' => $this->state,
            'date' => is_null($this->date) ? null : $this->date->toDateTime()->format("Y-m-d\TH:iO"),
            'date_modified' => is_null($this->dateModified) ? null : $this->dateModified->toDateTime()->format("Y-m-d\TH:iO"),
            'documents' => $this->documents,
            'position' => is_null($this->position) ? null : $this->position->toArray(),
            'discrepancy' => $this->discrepancy,
            'comment' => $this->comment,
            'status_code' => $this->statusCode ?? '',
        ];

        if (is_null($this->position)) {
            unset($details['position']);
        }

        return $details;
    }

    public static function fromArray(array $details, string $curtz): self
    {
        return new self(
            $details['state'],
            (new Carbon($details['date']))->tz($curtz),
            (new Carbon($details['date_modified']))->tz($curtz),
            $details['documents'],
            $details['position'] ? Position::fromArray($details['position'], $curtz) : null,
            $details['discrepancy'],
            $details['comment'] ?? self::DEFAULT_COMMENT,
            $details['status_code'] ?? null
        );
    }

    public function getStatusCode(): ?string
    {
        return $this->statusCode;
    }

    /**
     * @return Carbon
     */
    public function getDate(): ?Carbon
    {
        return $this->date;
    }

    /**
     * @return string
     */
    public function getComment(): string
    {
        return $this->comment;
    }
}
