<?php

namespace App\Mobile\V1\Trips\Model;

final class TripStatusCode
{
    public const NOT_STARTED_CODE = '0212';
    public const STARTED_CODE = '0219';
    public const FINISHED_CODE = '0218';

    public static function getCodeByStatus(string $tripStatus): ?string
    {
        return self::getCodeMap()[$tripStatus] ?? null;
    }

    public static function getStatusByCode(string $tripStatusCode): ?string
    {
        $flippedStatuses = array_flip(self::getCodeMap());

        return $flippedStatuses[$tripStatusCode] ?? null;
    }

    private static function getCodeMap(): array
    {
        return [
            TripStatus::NOT_STARTED => self::NOT_STARTED_CODE,
            TripStatus::STARTED => self::STARTED_CODE,
            TripStatus::FINISHED => self::FINISHED_CODE
        ];
    }
}
