<?php

namespace App\Mobile\V1\Trips\Model;

final class TripStatusId
{
    public const ACCEPTED_BY_DRIVER = 10;
    public const PLANNED_DELIVERY_DATE = 11;

    private const STATUS_ID_MAP = [
        TripStatusCode::NOT_STARTED_CODE => self::ACCEPTED_BY_DRIVER,
        TripStatusCode::STARTED_CODE => self::ACCEPTED_BY_DRIVER,
        TripStatusCode::FINISHED_CODE => self::PLANNED_DELIVERY_DATE
    ];

    /**
     * Gets trip status id
     *
     * @param string $tripStatusCode One of values represented by TripStatusCode
     *
     * @return int
     */
    public static function getStatusIdByCode(string $tripStatusCode): int
    {
        return self::STATUS_ID_MAP[$tripStatusCode] ?? 0;
    }
}
