<?php

namespace App\MobileEvents;

use CI_DB_mysqli_driver;
use Psr\EventDispatcher\ListenerProviderInterface;
use Uuid;

final class EventListenerProvider implements ListenerProviderInterface
{
    private $db;
    private $uuid;

    public function __construct(CI_DB_mysqli_driver $db, Uuid $uuid)
    {
        $this->db = $db;
        $this->uuid = $uuid;
    }

    public function getListenersForEvent(object $event): iterable
    {
        $listeners = [
            MobileEvent::class => [new MobileEventListener($this->db, $this->uuid)]
        ];

        return $listeners[get_class($event)];
    }
}
