<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\AssignDriverPayload;

final class AssignDriverEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof AssignDriverPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->sendfirebase->sendSinglePush($payload->toArray());
    }
}
