<?php

namespace App\MobileEvents\Handler;


use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\EventListenerProvider;
use App\MobileEvents\Payload\CloseTripOpenboxesPayload;
use App\MobileEvents\Payload\CloseTripPayload;
use League\Event\EventDispatcher;

final class CloseTripEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof CloseTripPayload) {
            throw new InvalidPayloadException;
        }

        if ($payload->shouldNotifyOpenboxes()) {
            $this->notifyOpenboxes($payload);
        }

        if ($payload->isStopUnitsPartiallyPicked()) {
            $this->CI->statusintigration->roadlogshipmenttripdeliverpartial($payload->toArray());
        } else {
            $this->CI->statusintigration->roadlogshipmenttripdelivered($payload->toArray());
        }
    }

    private function notifyOpenboxes(CloseTripPayload $payload): void
    {
        $eventDispatcher = new EventDispatcher(new EventListenerProvider($this->CI->db, new \Uuid()));
        $eventDispatcher->dispatch(
            new CloseTripOpenboxesPayload(
                '0212',
                $payload->getTripIdentity()->getOrderId(),
                $payload->getTripIdentity()->getTripId(),
                $payload->getDateTime(),
                $payload->getPosition()->getLatitude(),
                $payload->getPosition()->getLongitude()
            )
        );
    }
}
