<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\CloseTripOpenboxesPayload;

final class CloseTripOpenboxesEventHandler extends MobileEventHandler
{
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof CloseTripOpenboxesPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->openbox_status_execution->pushStatusExecutionXml(
            [
                "status" => $payload->getStatus(),
                "order_row_id" => $payload->getOrderRowId(),
                "trip_id" => $payload->getTripId(),
                "date_time" => $payload->getFormattedDateTime(),
                "lat" => $payload->getLat(),
                "long" => $payload->getLong(),
            ]
        );
    }
}
