<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\CloseTripSummaryPayload;

final class CloseTripSummaryEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     * @throws CloseTripSummaryNoDataException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof CloseTripSummaryPayload) {
            throw new InvalidPayloadException;
        }

        $curdt = date('Y-m-d H:i:s');
        $reg = "";
        $sql = $this->CI->db->query(
            "SELECT shift_id,vehicle_id,driver_id,
            convertToClientTZ(stime, ?) as stime,
            convertToClientTZ(etime, ?) as etime,
            etime as tetime, start_imei, end_imei, start_reading, end_reading, trip_type, plat, plng, dlat, dlng
        FROM tb_trips WHERE id = ? AND status = 0 LIMIT 1",
            [
                $payload->getCurrentTimeZoneName(),
                $payload->getCurrentTimeZoneName(),
                $payload->getTripId()
            ]
        );

        if ($sql->num_rows() === 0) {
            throw new CloseTripSummaryNoDataException(get_class($this) . ' found 0 rows in tb_trips');
        }

        $data = [
            'driver_name' => '',
            'driver_num' => '',
            'tripinfo' => $sql->row()
        ];
        $shift = $sql->row()->shift_id;

        $sql1 = $this->CI->db->query(
            "SELECT user_id,stime as setime,
                convertToClientTZ(startdate, ?) as startdate,
                convertToClientTZ(enddate, ?) as enddate,splace,eplace
            FROM tb_shifts
            WHERE id = ? LIMIT 1",
            [
                $payload->getCurrentTimeZoneName(),
                $payload->getCurrentTimeZoneName(),
                $shift
            ]
        );
        $data["trip"] = $sql1->row();
        $emp1 = $this->CI->db->query(
            "SELECT e.name,convertToClientTZ(te.stime, ?) as in_time,
                te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,
                e.shipment_volume,e.shipment_weight,e.order_id
            FROM tb_employee e, tb_trip_employee te, tb_materials m
            WHERE te.employee_id = e.id
            AND m.id = e.material_id
            AND te.trip_id = ?",
            [
                $payload->getCurrentTimeZoneName(),
                $payload->getTripId()
            ]
        );

        $emp = $this->CI->db->query(
            "SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt,
                count(e.employee_id) AS totcnt
            FROM tb_trip_employee e WHERE e.trip_id = ?",
            [
                $payload->getTripId()
            ]
        );
        $start = $sql->row()->stime;
        $end = $sql->row()->etime;
        $imei = $sql->row()->start_imei;
        $eimei = $sql->row()->end_imei;
        $driverid = $sql->row()->driver_id;
        $vehicleid = $sql->row()->vehicle_id;
        $stime = $sql1->row()->startdate;
        $etime = $sql1->row()->enddate;
        $uid = $sql1->row()->user_id;
        $odometer_start = trim($sql->row()->start_reading);
        $odometer_end = trim($sql->row()->end_reading);
        $trip_type = $sql->row()->trip_type;
        $vendor_id = 0;
        $trucks_query = $this->CI->db->query(
            "SELECT truck_capacity,register_number,vendor_id,truck_weight,truck_volume
            FROM tb_trucks_data
            WHERE id = ? LIMIT 1",
            [
                $vehicleid
            ]
        );
        $cab_capacity = $truck_weight = $truck_volume = 0;
        if ($trucks_query->num_rows() > 0) {
            $cab_capacity = $trucks_query->row()->truck_capacity;
            $reg = $trucks_query->row()->register_number;
            $vendor_id = $trucks_query->row()->vendor_id;
            $truck_weight = $trucks_query->row()->truck_weight;
            $truck_volume = $trucks_query->row()->truck_volume;
        }

        if ($cab_capacity == "") {
            $cab_capacity = 0;
        }
        $regg = $this->CI->db->query(
            "SELECT name,contact_num,vendor_id
            FROM tb_truck_drivers
            WHERE id = ? LIMIT 1",
            [
                $driverid
            ]
        );
        if ($regg->num_rows() > 0) {
            $data['driver_name'] = $regg->row()->name;
            $data['driver_num'] = $regg->row()->contact_num;
            $vnid = $regg->row()->vendor_id;
            if ($vendor_id == 0 && $vnid != 0) {
                $vendor_id = $vnid;
            }
        }

        $sql2 = $this->CI->db->query(
            "SELECT latitude,longitude,convertToClientTZ(`timestamp`, ?) as timestamp
            FROM tb_rtdrive_locations
            WHERE mobileimei = ?
            AND timestamp <= ?
            AND timestamp >= ?
            ORDER BY timestamp ASC",
            [
                $payload->getCurrentTimeZoneName(),
                $imei,
                $end,
                $start
            ]
        );
        $flag = 0;
        $lat = $lng = 0;
        $dist = 0;
        if ($sql2->num_rows() > 0) {
            foreach ($sql2->result() as $row) {
                if ($flag == 0) {
                    $flag = 1;
                } else {
                    $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                    $dist = $dist + $a;
                }
                $lat = $row->latitude;
                $lng = $row->longitude;
            }
        }
        $attendemp = 0;
        $totalemp = getempcount($payload->getTripId());
        if ($emp->num_rows() > 0) {
            $attendemp = $emp->row()->attcnt;
        }
        $data["noofemp"] = $totalemp;
        $driver_late = 0.00;
        $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
        $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
        $to_time = strtotime($setime);
        $from_time = strtotime($tetime);
        if ($from_time > $to_time) {
            $driver_late = round(abs($from_time - $to_time) / 60, 2);
        }
        $arr = [
            'trip_id' => $payload->getTripId(),
            'vehicle_id' => $vehicleid,
            'driver_id' => $driverid,
            'vendor_id' => $vendor_id,
            'trip_distance' => $dist,
            'no_of_emp' => $totalemp,
            'attended_emp' => $attendemp,
            'start_imei' => $imei,
            'end_imei' => $eimei,
            'start_time' => $stime,
            'end_time' => $etime,
            'user_id' => $uid,
            'cab_capacity' => $cab_capacity,
            'trip_status' => 1,
            'trip_type' => $trip_type,
            'ship_delay' => $driver_late,
            'createdon' => $curdt
        ];

        $chktrip = $this->CI->db->select('id')
            ->get_where('tb_trip_summary', ['trip_id' => $payload->getTripId()], 1, 0);
        if ($chktrip->num_rows() == 0) {
            $this->CI->db->insert("tb_trip_summary", $arr);
        }
        $data["trip_id"] = $payload->getTripId();
        if ($trip_type != 2) {
            $shti = $sql1->row()->startdate;
            $shifttime = date('H:i A', strtotime($shti));
        } else {
            $shifttime = "Empty";
        }

        $data["page_title"] = "Trip Report";
        $data["driver_late"] = $driver_late;
        $data["empshifttime"] = $shifttime;
        $data["distance"] = $dist;
        $data["stime"] = $stime;
        $data["etime"] = $etime;
        $data["simei"] = $imei;
        $data["eimei"] = $eimei;
        $data["capacity"] = $cab_capacity;
        $data["employees"] = $emp1;
        $data["trip_type"] = $trip_type;
        $data["register_number"] = $reg;
        $data["truck_weight"] = $truck_weight;
        $data["truck_volume"] = $truck_volume;
        $data["ep"] = "";
        if ($odometer_end == "") {
            $odometer_end = 0;
        }
        if ($odometer_start == "") {
            $odometer_start = 0;
        }
        $data["odometer"] = ($odometer_end - $odometer_start);

        $getusermail = $this->CI->db->select("name,emailid,cc_mails,address")
            ->get_where("tb_users", ["id" => $uid, "emailid !=" => ""], 1, 0);

        if ($getusermail->num_rows() === 0) {
            /**
             * Trip summary was updated, even if we don't send an email we treat that handler did its job.
             * It means that for now we are not able to investigate emails that were not send when they should.
             */
            return;
        }

        $receivemail = $getusermail->row()->emailid;
        $receivename = $getusermail->row()->name;
        $receivecc = $getusermail->row()->cc_mails;
        $data["ep"] = $getusermail->row()->address;
        $insertdata = @array(
            'trip_id' => $payload->getTripId(),
            'shift_id' => $shift,
            'splace' => $data["trip"]->splace,
            'eplace' => $data["trip"]->eplace,
            'stime' => $stime,
            'etime' => $etime,
            'capacity' => $cab_capacity,
            'simei' => $data['simei'],
            'eimei' => $data['eimei'],
            'totcnt' => $totalemp,
            'attcnt' => $attendemp,
            'distance' => $data['distance'],
            'odometer' => $data['odometer'],
            'driver_late' => $data['driver_late'],
            'receivemail' => $receivemail,
            'receivename' => $receivename,
            'user_id' => $uid,
            'createdon' => $curdt
        );

        $this->CI->db->insert('tb_trips_mails', $insertdata);

        $this->notifyTripStatus($receivemail, $receivecc ?? '', $this->getEmailSubject($trip_type), $data);
    }

    /**
     * Returns subject for email based on Trip type
     *
     * @param mixed $tripType 1 - Return, 2 - Empty Trip
     *
     * @return string
     */
    private function getEmailSubject($tripType): string
    {
        if ($tripType == 1) {
            return 'svkonekt: Return Trip Status';
        }

        if ($tripType == 2) {
            return 'svkonekt: Empty Trip Status';
        }

        return 'svkonekt: Trip Status';
    }

    /**
     * Sends svkonekt system email to inform Trip Status
     *
     * @param string $receivemail Email address of receiver
     * @param string $receivecc CC email address
     * @param string $subject Subject for the email
     * @param array $data Data to fill the email
     *
     * @return void
     */
    private function notifyTripStatus(
        string $receivemail,
        string $receivecc,
        string $subject,
        array $data
    ): void {
        $this->CI->load->library('email');
        $this->CI->email->to($receivemail);
        if ($receivecc != '') {
            $this->CI->email->cc($receivecc);
        }
        $this->CI->email->from('svkonekt@kuehne-nagel.com', 'eTrucksvkonektnow');
        $this->CI->email->subject($subject);
        $this->CI->email->set_mailtype('html');
        $body = $this->CI->load->view('mail_forms/basicreport', $data, true);
        $this->CI->email->message($body);
        $this->CI->email->send();
        $this->CI->email->clear(true);
    }
}
