<?php

namespace App\MobileEvents\Handler;

class MilestoneUpdateXmlChecker
{
    private static $isTest = false;
    private static $xmls = [];
    private static $callers = [];

    public static function startNewTest(): void
    {
        static::$isTest = true;
        static::$xmls = [];
        static::$callers = [];
    }

    public static function isTest(): bool
    {
        return static::$isTest;
    }

    public static function rememberXml(string $xml): void
    {
        static::$xmls[] = $xml;
        static::$callers[] = debug_backtrace()[1];
    }

    public static function getXmls(): array
    {
        return static::$xmls;
    }

    public static function getCallers(): array
    {
        return static::$callers;
    }
}
