<?php

namespace App\MobileEvents\Handler;

use App\MobileEvents\MobileEvent;
use App\MobileEvents\MobileEventHandlerNotFoundException;
use App\EventsQueue\Handler\TripNotificationHandler;

final class MobileEventHandlerProvider
{
    /**
     * @throws MobileEventHandlerNotFoundException
     */
    public function __invoke(?string $eventName): string
    {
        switch ($eventName) {
            case MobileEvent::EVENT_START_TRIP:
                return StartTripEventHandler::class;
            case MobileEvent::EVENT_START_MULTIPLE_SHIPMENTS:
                return StartMultipleTripsEventHandler::class;
            case MobileEvent::EVENT_CLOSE_TRIP:
                return CloseTripEventHandler::class;
            case MobileEvent::EVENT_CLOSE_TRIP_GENERATE_SUMMARY:
                return CloseTripSummaryEventHandler::class;
            case MobileEvent::EVENT_CLOSE_TRIP_NOTIFY_OPENBOXES;
                return CloseTripOpenboxesEventHandler::class;
            case MobileEvent::EVENT_UPLOAD_POD:
                return PodUploadsEventHandler::class;
            case MobileEvent::EVENT_UPLOAD_SIGNATURE:
                return SignatureUploadsEventHandler::class;
            case MobileEvent::EVENT_MILESTONE_STATUS:
                return MilestoneUpdateEventHandler::class;
            case MobileEvent::EVENT_RESCHEDULE_TRIP:
                return RescheduleTripEventHandler::class;
            case MobileEvent::EVENT_REJECT_TRIP:
                return RejectTripEventHandler::class;
            case MobileEvent::EVENT_ABORT_TRIP:
                return AbortTripEventHandler::class;
            case MobileEvent::EVENT_STOP_STATUS_UPDATE:
                return StopStatusUpdateEventHandler::class;
            case MobileEvent::EVENT_ASSIGN_DRIVER:
                return AssignDriverEventHandler::class;
            case MobileEvent::EVENT_UPLOAD_CUSTOMS:
                return UploadCustomsEventHandler::class;
            case MobileEvent::EVENT_REMOVE_POD:
                return RemovePodEventHandler::class;
            case MobileEvent::EVENT_DRIVER_COLLECTION:
                return DriverCollectionEventHandler::class;
            case MobileEvent::EVENT_PANIC_ALERT:
                return PanicAlertEventHandler::class;
            case MobileEvent::EVENT_DUMMY:
                return DummyEventHandler::class;
            case MobileEvent::EVENT_UPLOAD_GENERATED_EPOD:
                return UploadGeneratedEpodHandler::class;
            case 'mobile.trip.outbound':
                return TripNotificationHandler::class;
            default:
                throw new MobileEventHandlerNotFoundException();
        }
    }
}
