<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\PanicAlertPayload;

final class PanicAlertEventHandler extends MobileEventHandler
{
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof PanicAlertPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->load->library('email');
        $this->CI->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->CI->email->to($payload->getUserEmail());
        $this->CI->email->subject("svkonekt::Panic button triggered on " . $payload->getRegisterNumber());
        $this->CI->email->set_mailtype("html");
        $this->CI->email->message($this->CI->load->view("mail_forms/panic_alert", $payload->toArray(), true));
        $this->CI->email->send();
        $this->CI->email->clear(true);
    }
}
