<?php

namespace App\MobileEvents\Handler;

use App\ApiRequest\SendDocumentGateOut;
use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\PodUploadsPayload;
use App\NotificationManagement\NotificationManager;

final class PodUploadsEventHandler extends MobileEventHandler
{
    /**
     * @throws \Mpdf\MpdfException
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof PodUploadsPayload) {
            throw new InvalidPayloadException;
        }
        $status_id = $payload->getMilestoneIdentity()->getStatusId();
        if ($status_id == '3') {
            $this->CI->statusintigration->roadlogorderpodstatus($payload->toArray());
            SendDocumentGateOut::sendshipstatusnotify($payload->toArray(), 6, $this->CI);
            NotificationManager::notify(
                $this->CI,
                'pod_note',
                $payload->getTripIdentity()->getOrderId(),
                NEW_POD_PATH . $payload->getDocument()->getFileName()
            );
        }
        if ($payload->getCreatedSource() == 9) {
            $postdata = $payload->toArray();
            $postdata['user_id'] = $payload->getUserId();
            $postdata['ord_id'] = $payload->getTripIdentity()->getOrderId();
            $postdata['status_code'] = '3060';
            $this->CI->svkonektquote->getstatusresponse($postdata);
        }
        if ($this->CI->commonpodedi->checkDocumentType($status_id)) {
            $this->CI->commonpodedi->sendpodoutboundxml(
                $payload->getTripIdentity()->getOrderId(),
                $payload->getDocument()->getFileName(),
                $status_id
            );
        }
    }
}
