<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\RejectTripPayload;

final class RejectTripEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof RejectTripPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->statusintigration->roadlogshipmentreject($payload->toArray());
    }
}
