<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\RescheduleTripPayload;

final class RescheduleTripEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof RescheduleTripPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->load->library('email');
        $this->CI->email->from("svkonekt@kuehne-nagel.com", "svkonekt");
        if (!empty($payload->getCarrier()->getEmail())) {
            $this->CI->email->to($payload->getCarrier()->getEmail(), $payload->getCarrier()->getName());
        }
        if (!empty($payload->getUser()->getEmail())) {
            $this->CI->email->cc($payload->getUser()->getEmail(), $payload->getUser()->getName());
        }
        $this->CI->email->subject('Shipment reschedule requested');
        $this->CI->email->set_mailtype('html');
        $this->CI->email->message("
            Hi,<br><br>
            Your shipment had a rescheduling request from driver<br><br>
            <table style=\"border: 1px solid #f4f4f4;width: 100%;\">
            <tbody><tr style=\"background-color: gray;color: white;\">
            <th>Shipment Id</th>
            <th>Start Place</th>
            <th>End Place</th>
            <th>All materials are swapped in good condition</th>
            <th>Actual Date</th>
            <th>Re-scheduling Date</th>
            <th>Re-scheduling reason</th>
            </tr>
            <tr>
            <td>" . $payload->getShift()->getShipmentId() . "</td>
            <td>" . $payload->getShift()->getStartPlace() . "</td>
            <td>" . $payload->getShift()->getEndPlace() . "</td>
            <td>" . $payload->getCheck() . "</td>
            <td>" . $payload->getShift()->getStartDate() . "</td>
            <td>" . $payload->getRescheduleDate() . "</td>
            <td>" . $payload->getReason() . "</td>
            </tr>
            </tbody></table><br>
            Driver Details:<br>
            <table style=\"border: 1px solid #f4f4f4;\">
            <tbody><tr style=\"background-color: gray;color: white;\">
            <th>Driver</th>
            <th>Mobile</th>
            </tr>
            <tr>
            <td>" . $payload->getDriver()->getName() . "</td>
            <td>" . $payload->getDriver()->getContactNumber() . "</td>
            </tr>
            </tbody></table><br>
            <a href='" . base_url() . "' target='_blank' title='Click here to Accept/Reject this request'>Click here</a> to Accept/Reject this request<br><br>
            Thanks,<br>
            Support Team,<br>
            Svkonekt.
            ");

        $this->CI->email->send();
        $this->CI->email->clear(true);
    }
}
