<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\EventListenerProvider;
use App\MobileEvents\MobileEvent;
use App\MobileEvents\Payload\SignatureUploadsPayload;
use App\MobileEvents\Payload\UploadGeneratedEpodPayload;
use App\PodUploads\MakePod\MakePodFromOrderAndSignature;
use CI_Controller;
use League\Event\EventDispatcher;

final class SignatureUploadsEventHandler extends MobileEventHandler
{
    public function __construct(CI_Controller $CI, string $eventName = null)
    {
        parent::__construct($CI, $eventName);
        $this->CI->load->library('uuid');
        $this->eventDispatcher = new EventDispatcher(new EventListenerProvider($this->CI->db, $this->CI->uuid));
    }

    /**
     * @param SignatureUploadsPayload $payload
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof SignatureUploadsPayload) {
            throw new InvalidPayloadException();
        }

        $data = $payload->getPodData();
        $processor = new MakePodFromOrderAndSignature($this->CI);
        $fileName = $processor->make($data);

        $shipment_id = $payload->getTripIdentity()->getShiftId();
        $stop_id = $payload->getMilestoneIdentity()->getStopId();
        $stop_type = $payload->getMilestoneIdentity()->getStopType();
        $stop_detail_id = empty($payload->getStopDetailId()) ? 0 : $payload->getStopDetailId();
        $latitude = $payload->getPosition()->getLatitude();
        $longitude = $payload->getPosition()->getLongitude();
        $status_type = $payload->getDocument()->getDocumentType();
        $ordid = $payload->getTripIdentity()->getOrderId();
        $uid = $payload->getUserId();
        $driver_id = $payload->getTripIdentity()->getDriverId();
        $curdt = new \DateTime();
        $companyCode = $payload->getPodData()->getCompanyCode();

        $filesize = filesize($fileName);
        $newUuid = $this->CI->uuid->v4();
        $filedata = ['shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $payload->getTripIdentity()->getTripId(), 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_type, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt->format('Y-m-d H:i:s'), 'filesize' => $filesize, 'hash' => $newUuid];
        $this->CI->db->insert("tb_pod_uploads", $filedata);

        if ($companyCode === 'UKKN-CG') {
            $epod = new UploadGeneratedEpodPayload(
                $payload->getTripIdentity(), $payload->getPosition(), $payload->getCreatedSource(), $payload->getUserId(), $payload->getCurrentDateTime(),
                $payload->getCurrentTimeZone(), $payload->getOffset(), $payload->getMilestoneIdentity(), $payload->getDocument(), $fileName
            );
            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_UPLOAD_GENERATED_EPOD, $epod));
        }
    }
}
