<?php

namespace App\MobileEvents;

use App\EventsQueue\EventListener;
use App\EventsQueue\EventQueue;
use CI_DB_mysqli_driver;
use Uuid;

final class MobileEventListener extends MobileEventType implements EventListener
{
    private $db;
    private $uuid;

    public function __construct(CI_DB_mysqli_driver $db, Uuid $uuid)
    {
        $this->db = $db;
        $this->uuid = $uuid;
    }


    public function __invoke(object $event): void
    {
        if ($event instanceof MobileEvent) {
            $data['id'] = $this->uuid->v4();
            $data['event_name'] = $event->eventName();
            $data['payload'] = serialize($event->payload());
            $this->db->insert(EventQueue::TABLE, $data);
        }
    }
}
