<?php

namespace App\MobileEvents\Payload;

abstract class AbstractEdiPayload implements IsSalogPayload, IsShippeoPayload, IsSvkonektQuotePayload
{
    /**
     * SALOG is represented by createdSource == 5
     *
     * @return bool
     */
    public function isSalog(): bool
    {
        return $this->getCreatedSource() == '5';
    }

    /**
     * Shippeo is represented by createdSource == 8
     *
     * @return bool
     */
    public function isShippeo(): bool
    {
        return $this->getCreatedSource() == '8';
    }

    /**
     * Svkonekt Quote is represented by createdSource == 9
     *
     * @return bool
     */
    public function isSvkonektQuotePayload(): bool
    {
        return $this->getCreatedSource() == '9';
    }

    abstract public function getCreatedSource(): string;
    abstract public function getDataToSvkonektQuote(): array;
}