<?php

namespace App\MobileEvents\Payload\Document;

use Exception;

final class UploadDocument
{
    /**
     * @var string
     */
    private $fileName;
    /**
     * @var string
     */
    private $fileType;
    /**
     * @var string
     */
    private $documentType;
    /**
     * @var string
     */
    private $documentTypeId;

    /**
     * @param string $fileName
     * @param string $fileType
     * @param string $documentType
     * @param string|null $documentTypeId
     * @throws Exception
     */
    public function __construct(string $fileName, string $fileType, string $documentType, ?string $documentTypeId)
    {
        $this->fileName = $fileName;
        $this->fileType = $fileType;
        $this->documentType = $documentType;
        $this->documentTypeId = $documentTypeId;
        if ($this->validatePayload() === false) {
            throw new Exception('Upload document is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getFileName());
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return $this->fileName;
    }

    /**
     * @return string
     */
    public function getDocumentType(): string
    {
        return $this->documentType;
    }

    /**
     * @return string
     */
    public function getFileType(): string
    {
        return $this->fileType;
    }

    /**
     * @return string
     */
    public function getDocumentTypeId(): string
    {
        return $this->documentTypeId;
    }
}
