<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\AbortTripPayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeImmutable;
use DateTimeZone;
use Exception;

final class AbortTripPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $createdSource,
        string $orderId,
        string $legOrderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentDateTime,
        string $currentTimeZone,
        string $offset
    ): AbortTripPayload
    {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentDateTime = new DateTimeImmutable($currentDateTime);
        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new AbortTripPayload($tripIdentity, $position, $createdSource, $userId, $currentDateTime, $currentTimeZone, $offset, $legOrderId);
    }
}