<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\CloseTripSummaryPayload;
use DateTimeZone;
use Exception;

final class CloseTripSummaryPayloadFactory
{
    /**
     * @throws Exception When parameters were invalid
     */
    public static function create(
        string $tripId,
        string $currentTimeZone
    ): CloseTripSummaryPayload {
        if ($currentTimeZone === '') {
            $currentTimeZone = date_default_timezone_get();
        }

        $currentTimeZone = new DateTimeZone($currentTimeZone);
        if ($tripId === '') {
            throw new Exception('Trip id is required to create Close Trip Summary Payload');
        }

        return new CloseTripSummaryPayload($tripId, $currentTimeZone);
    }
}
