<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\DriverCollectionPayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeZone;
use Exception;

class DriverCollectionPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $createdSource,
        string $orderId,
        string $legOrderId,
        string $stopLegId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentTimeZone,
        string $offset
    ): DriverCollectionPayload
    {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new DriverCollectionPayload($tripIdentity, $position, $createdSource, $userId, $currentTimeZone, $offset, $legOrderId, $stopLegId);
    }
}