<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Milestone\MilestoneIdentity;
use App\MobileEvents\Payload\MilestoneUpdatePayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeZone;

final class MilestoneUpdatePayloadFactory
{
    public static function create(
        string $createdSource,
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentTimeZone,
        string $offset,
        string $stopId,
        string $legOrderId,
        string $incrementId,
        string $statusId,
        string $stopType,
        string $comment
    ): MilestoneUpdatePayload {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentTimeZone = new DateTimeZone($currentTimeZone);

        $milestone = new MilestoneIdentity($stopId, $legOrderId, '-1', $incrementId, $statusId, $stopType);

        return new MilestoneUpdatePayload($tripIdentity, $position, $createdSource, $userId, $currentTimeZone, $offset, $milestone, $comment);
    }
}
