<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Driver\DriverIdentity;
use App\MobileEvents\Payload\PanicAlertPayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\User\UserIdentity;
use Exception;

class PanicAlertPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $name,
        string $email,
        string $registerNumber,
        string $latitude,
        string $longitude,
        string $driverName,
        string $driverMobile,
        string $shipmentId,
        string $startPlace,
        string $endPlace
    ): PanicAlertPayload
    {
        $position = new OptionalPosition($latitude, $longitude);
        $user = new UserIdentity($email, $name);
        $driver = new DriverIdentity($driverMobile, $driverName);

        return new PanicAlertPayload($position, $user, $driver, $registerNumber, $shipmentId, $startPlace, $endPlace);
    }
}