<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\RejectTripPayload;
use App\MobileEvents\Payload\Trip\OptionalTripIdentity;
use DateTimeImmutable;
use DateTimeZone;

final class RejectTripPayloadFactory
{
    /**
     * @throws \Exception
     */
    public static function create(
        string $createdSource,
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentDateTime,
        string $currentTimeZone,
        string $offset
    ): RejectTripPayload {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new OptionalTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentDateTime = new DateTimeImmutable($currentDateTime);
        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new RejectTripPayload($tripIdentity, $position, $createdSource, $userId, $currentDateTime, $currentTimeZone, $offset);
    }
}
