<?php

namespace App\MobileEvents\Payload\Position;

use Exception;

abstract class Position
{
    /** @var string Position latitude */
    protected $latitude;

    /** @var string Position longitude */
    protected $longitude;

    /**
     * @param string $latitude
     * @param string $longitude
     *
     * @throws Exception When position is invalid
     */
    public function __construct(string $latitude, string $longitude)
    {
        $this->latitude = $latitude;
        $this->longitude = $longitude;
        if ($this->validatePayload() === false) {
            throw new Exception('Position is invalid');
        }
    }

    abstract protected function validatePayload(): bool;

    /**
     * @return string
     */
    public function getLatitude(): string
    {
        return $this->latitude;
    }

    /**
     * @return string
     */
    public function getLongitude(): string
    {
        return $this->longitude;
    }
}
