<?php

namespace App\MobileEvents\Payload;

use App\MobileEvents\Payload\Document\UploadDocument;
use App\MobileEvents\Payload\Milestone\MilestoneIdentity;
use App\MobileEvents\Payload\Position\Position;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeImmutable;
use DateTimeZone;

class UploadGeneratedEpodPayload extends PodUploadsPayload
{
    private $ePodFileName;

    public function __construct(RequiredTripIdentity $tripIdentity, Position $position, string $createdSource, string $userId, DateTimeImmutable $currentDateTime, DateTimeZone $currentTimeZone, string $offset, MilestoneIdentity $milestoneIdentity, UploadDocument $document, string $ePodFileName)
    {
        parent::__construct($tripIdentity, $position, $createdSource, $userId, $currentDateTime, $currentTimeZone, $offset, $milestoneIdentity, $document);
        $this->ePodFileName = $ePodFileName;
    }

    /**
     * @return string
     */
    public function getEPodFileName(): string
    {
        return $this->ePodFileName;
    }
}
