<?php

namespace App\MobileEvents\Payload\User;


use Exception;

final class UserIdentity
{
    /**
     * @var string
     */
    private $email;
    /**
     * @var string
     */
    private $name;

    /**
     * @param string $email
     * @param string $name
     * @throws Exception
     */
    public function __construct(string $email, string $name)
    {
        $this->email = $email;
        $this->name = $name;

        if ($this->validatePayload() === false) {
            throw new Exception('User is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getName());
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }
}