<?php
namespace App\NotificationManagement;

class NotificationManager
{
    public static function notify(\CI_Controller $CI, $action, $orderid, $attach = null){
        if (!empty($orderid)) {
            $CI->load->library('notifytrigger');
            if ($attach != null) {
                $info['attachment'] = $attach;
            }
            $info['page_title'] = 'Booking Notification';

            $orderinfo = $CI->common->gettblrowdata(array('id' => $orderid), 'id,order_id', 'tb_orders', 0, 0);
            if (count($orderinfo) > 0) {
                $info['order_id'] = $orderinfo['id'];
                $info['orderid'] = $bookingId = $orderinfo['order_id'];
                $CI->load->model('DeliveryDocumentModel');
                $orderDetails = $CI->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $info['action'] = $action;
                $info['cargos'] = $CI->common->gettbldata(array('order_id' => $info['order_id']), 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $info['body'] = $CI->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $sendnote = $CI->notifytrigger->sendordernotify($info);
            }
        }
    }
}
