<?php

namespace App\Pagination;

class PaginationResponse
{
    /**
     * @var int
     */
    private $currentPage;
    /**
     * @var bool
     */
    private $hasNextPage;
    /**
     * @var bool
     */
    private $hasPreviousPage;
    /**
     * @var array
     */
    private $items;
    /**
     * @var int
     */
    private $limit;
    /**
     * @var array
     */
    private $urlArguments;

    public function __construct(
        array $items = [],
        bool $hasNextPage = false,
        bool $hasPreviousPage = false,
        int $limit = 10,
        int $currentPage = 1,
        array $urlArguments = []
    ) {
        $this->items = $items;
        $this->hasNextPage = $hasNextPage;
        $this->hasPreviousPage = $hasPreviousPage;
        $this->limit = $limit;
        $this->currentPage = $currentPage;
        $this->urlArguments = $urlArguments;
    }

    public function items(): array
    {
        return $this->items;
    }

    public function hasItems(): bool
    {
        return !empty($this->items);
    }

    public function __toString(): string
    {
        $paginationBuilder = new DataTablesPaginationBuilder(
            $this->limit,
            $this->currentPage,
            $this->hasPreviousPage,
            $this->hasNextPage,
            $this->urlArguments
        );

        return $paginationBuilder->renderHtml();
    }

    public function renderPagination(): string
    {
        return (string)$this;
    }

    public function updateItems(array $items): void
    {
        $this->items = $items;
    }
}
