<?php

namespace App\Pagination;

use CI_DB_query_builder;

class QueryPaginator
{
    /**
     * @var int
     */
    private $limit;
    /**
     * @var int
     */
    private $nextOffset;
    /**
     * @var CI_DB_query_builder
     */
    private $nextResultsQuery;
    /**
     * @var int
     */
    private $offset;
    /**
     * @var CI_DB_query_builder
     */
    private $query;

    public function __construct(CI_DB_query_builder $query, int $limit, int $offset, int $nextOffset)
    {
        $this->query = $query;
        $this->nextResultsQuery = clone $query;
        $this->limit = $limit;
        $this->offset = $offset;
        $this->nextOffset = $nextOffset;
    }

    public function paginateResults(): array
    {
        $query = $this->query;

        if ($this->limit > 0) {
            $query->limit($this->limit, $this->offset);

        }

        $results = $query->get();

        if ($results->num_rows === 0) {
            return [];
        }

        return $results->result_array();
    }

    public function nextPageContainsResults(): bool
    {
        $this->nextResultsQuery->limit($this->limit, $this->nextOffset);

        return $this->nextResultsQuery->get()->num_rows() > 0;
    }
}
