<?php

namespace App\PalletLabel\Zpl;

use App\PalletLabel\BarCode;

final class ZplBarCode implements BarCode
{
    public function getNext(string $previousBarCode): string
    {
        $consignmentNote = substr($previousBarCode, 0, -4);
        $last4Digits = substr($previousBarCode, -4);
        $last4Digits++;

        return $consignmentNote . str_pad($last4Digits, 4, '0', STR_PAD_LEFT);
    }

    public function getFirstForConsignment(string $consignmentNote): string
    {
        return $consignmentNote . "0001";
    }
}