<?php

namespace App\PalletLabel\Zpl;

use App\PalletLabel\Label;
use App\PalletLabel\LabelGenerator;

final class ZplLabelGenerator implements LabelGenerator
{
    public function generate(array $labelData): Label
    {
        switch (strtoupper($labelData['carrier_name'])) {
            case "BEX":
            case "BORDER EXPRESS":
                $labelData['carrier_new_name'] = 'REGIONAL';
                return new BexLabel($labelData);
            case "BONDS TRANSPORT":
                $labelData['carrier_new_name'] = 'METRO';
                return new BondsTransportLabel($labelData);
            case "BONDS DC":
                $labelData['carrier_new_name'] = 'DC';
                return new BondsDcLabel($labelData);
        }

        return new GenericLabel($labelData);
    }
}